
import cadquery as cq

# Start with a new workplane to create the annulus shape by making two concentric circles
result = cq.Workplane("XY").circle(10).circle(5)

# Extrude the annulus shape to form a 3D cylinder with height 5
result = result.extrude(5)

# Now, select the bottom face and create a solid circle to fill the central hole
result = result.faces("<Z").workplane().circle(5).extrude(-5)

# Save the output
result.val().exportStl("Refine_V_1.stl")
