
import cadquery as cq

# Create a workplane, then create an annular (ring-shaped) solid by subtracting a smaller circle from a larger circle
result = cq.Workplane("XY").circle(10).circle(5).extrude(5)

# Select the bottom end of the cylinder and close it by creating a new face
result = result.faces("<Z").workplane().hole(10)

# Export the modified solid to STL
result.val().exportStl("Refine_V_2.stl")
