
import cadquery as cq

# Create the bulb of the thermometer at the bottom
bulb = cq.Workplane("XY").circle(5).extrude(0.5)

# Create the tube stem of the thermometer
stem = cq.Workplane("XY").transformed(offset=(0, 25, 0)).circle(1).extrude(0.45)

# Combine the bulb and stem to form the complete thermometer
thermometer = bulb.union(stem)

# Export the final model to an STL file
thermometer.val().exportStl("Refine_V_1.stl")
