
import cadquery as cq

brick_length = 1.0
brick_width = 1.0
brick_height = 1.8
stud_height = brick_height / 7
stud_diameter = brick_width / 2

# Create the main rectangular body of the Lego brick
brick = (
    cq.Workplane("XY")
    .box(brick_length, brick_width, brick_height)
    .faces("<Z")
    .shell(-0.1)  # Hollow out the object with a small thickness
)

# Add the circular stud on top
brick = (
    brick.faces(">Z")
    .workplane()
    .circle(stud_diameter / 2)
    .extrude(stud_height)
)

# Export the refined model
brick.val().exportStl("Refine_V_1.stl")
