
import cadquery as cq

# Define the dimensions
outer_radius = 10.0  # Outer radius of the cylinder
inner_radius = 0.1  # Radius of the small hole
height = 20.0  # Height of the cylinder

# Create the outer cylinder
result = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the small hole
result = result.faces(">Z").workplane().circle(inner_radius).cutThruAll()

# Export the result
result.val().exportStl("Generated.stl")
