
import cadquery as cq

# Define the side length of the square
side_length = 10.0

# Create a square and extrude it to twice the side length
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length)  # Corrected to have a square base
    .extrude(side_length * 2)  # Correct extrusion length per the feedback
)

# Export the result to an STL file as requested
result.val().exportStl("Refine_V_1.stl")
