
import cadquery as cq

main_square_size = 10.0
small_square_size = main_square_size / 5

result = (
    cq.Workplane("XY")
    .rect(main_square_size, main_square_size)
    .extrude(main_square_size)
)

result = (
    result
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .transformed(offset=(main_square_size/2 - small_square_size/2, main_square_size/2 - small_square_size/2, 0))
    .rect(small_square_size, small_square_size)
    .cutBlind(-main_square_size)
)

result.val().exportStl("Refine_V_1.stl")
