
import cadquery as cq

length = 80.0
width = 60.0
thickness = 10.0

# Assuming '1/8th the size' refers to area approximation but maintaining a more rectangular shape closer to the feedback
hole_length = length / 4
hole_width = width / 8

result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Positioning the hole closer to the bottom
# Initially used coordinates related to the rectangle size
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .rect(hole_length, hole_width)
    .translate((0, -width/4, 0))  # translating the hole closer to the bottom edge
    .cutBlind(-thickness)
)

result.val().exportStl("Refine_V_1.stl")
