
import cadquery as cq

# Create a rectangular block with dimensions 10x20 and extrude it to a height of 30
result = cq.Workplane("front").rect(10, 20).extrude(30)

# Create a hollow cylinder by cutting a circle that is centered in the middle of the rectangle
# Center at half of the rectangle's width (10/2) and height (20/2)
result = result.faces(">Z").workplane().center(10/2, 20/2).circle(5).cutThruAll()

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
