
import cadquery as cq

outer_radius = 50.0
inner_radius = 45.0
height = 100.0

# Creating the hollow cylinder and extruding it
result = cq.Workplane("XY").circle(outer_radius).circle(inner_radius).extrude(height)

# Closing the cylinder at the bottom by selecting the bottom face and adding a disk
result = result.faces("<Z").workplane().circle(inner_radius).circle(outer_radius).extrude(-5)

# Adjust the code to add a tiny hollow circle on the top face
tiny_outer_radius = 5.0
tiny_inner_radius = 3.0
result = result.faces(">Z").workplane().center(0, 0).circle(tiny_outer_radius).circle(tiny_inner_radius).extrude(5)

# Export the result as STL file
result.val().exportStl("Refine_V_1.stl")
