
import cadquery as cq

original_size = 10.0
original_extrusion = 1.0
hollow_size = original_size / 2
second_size = original_size * 3 / 4
second_extrusion = original_extrusion / 4
tiny_size = 0.5
tiny_extrusion = 0.1

# Create the base rectangle and extrude
result = cq.Workplane("XY").rect(original_size, original_size).extrude(original_extrusion)

# Create a rectangular hollow in the center of the base
result = result.faces(">Z").workplane().rect(hollow_size, hollow_size).cutBlind(-original_extrusion)

# Create the second smaller rectangle on top of the base and extrude
result = result.faces(">Z").workplane().rect(second_size, second_size).extrude(second_extrusion)

# Create two tiny rectangles extruded, positioned as required
result = result.faces(">Z").workplane(centerOption='CenterOfBoundBox') \
    .transformed(offset=cq.Vector(-second_size/4, -second_size/4)) \
    .rect(tiny_size, tiny_size).extrude(tiny_extrusion)
result = result.faces(">Z").workplane(centerOption='CenterOfBoundBox') \
    .transformed(offset=cq.Vector(second_size/4, -second_size/4)) \
    .rect(tiny_size, tiny_size).extrude(tiny_extrusion)

# Export the result
result.val().exportStl("Refine_V_1.stl")
