
import cadquery as cq

base1 = 10.0
height1 = 20.0
extrude_dist1 = 10.0

# Creating the first trapezoid
result = (
    cq.Workplane("front")
    .moveTo(-base1 / 2, 0)
    .lineTo(base1 / 2, 0)
    .lineTo(base1 / 4, height1)  # Adjusting to keep the side perpendicular to the base
    .lineTo(-base1 / 4, height1)
    .close()
    .extrude(extrude_dist1)
)

base2_offset = 4.0  # Increased to ensure the second trapezoid is larger
extrude_dist2 = 2.0
height2 = height1 + base2_offset  # To make it a right trapezoid with increased height

# Creating the second trapezoid
result2 = (
    cq.Workplane("front")
    .workplane(offset=extrude_dist1)
    .moveTo(-(base1 + base2_offset) / 2, 0)
    .lineTo((base1 + base2_offset) / 2, 0)
    .lineTo((base1/4 + base2_offset), height2)  # Adjusting to keep the side perpendicular to the base
    .lineTo(-(base1/4 + base2_offset), height2)
    .close()
    .extrude(extrude_dist2)
)

# Combining both trapezoids
result = result.union(result2)

result.val().exportStl("Refine_V_2.stl")
