
import cadquery as cq

# Redefine dimensions based on feedback
large_rectangle_length = 10.0
large_rectangle_width = 5.0
large_rectangle_extrusion = 2.0

# Adjust dimensions and extrusions of the smaller rectangle
small_rectangle_length = large_rectangle_length / 2
small_rectangle_width = large_rectangle_width / 2
small_rectangle_extrusion = large_rectangle_extrusion * 2  # Clear doubling of extrusion

# Create large rectangle in XY plane
large_rectangle = (
    cq.Workplane("XY")
    .rect(large_rectangle_length, large_rectangle_width)
    .extrude(large_rectangle_extrusion)
)

# Create small rectangle in YZ plane, centered and correctly repositioned
small_rectangle = (
    cq.Workplane("YZ")
    .center(0, large_rectangle_width / 4)  # Center small rectangle midpoint to larger one
    .rect(small_rectangle_width, small_rectangle_length)
    .extrude(-small_rectangle_extrusion)  # Adjust extrusion direction for better union
    .translate((0, large_rectangle_width / 2, large_rectangle_extrusion))  # Translate for accurate placement
)

# Union the two parts
result = large_rectangle.union(small_rectangle)

# Export the updated model
result.val().exportStl("Refine_V_2.stl")
