
import cadquery as cq

# Define the points such that the lower part forms a rectangle
# Adjusted to form a rectangular base on the bottom with accurate pentagonal shape up top
points = [(0, 0), (10, 0), (10, 5), (5, 10), (0, 5)]

# Create the workplane and form the polygon
result = cq.Workplane("front").polyline(points).close()

# Extrude vertically to form a uniform pentagonal prism
result = result.extrude(10)  # uniform extrusion without deformation along height

# Export the model to an STL file
result.val().exportStl("Refine_V_1.stl")
