
import cadquery as cq

# Create a new workplane that the rectangle will be drawn on
# Define the rectangle with right angles by specifying the exact dimensions
rectangle = cq.Workplane("XY").rect(10, 20)  # 10 units wide, 20 units tall

# Extrude the sketch to turn it into a 3D object
# The distance of extrusion is 5 units upward from the workplane
extruded_rectangle = rectangle.extrude(5)

# Creating a hole in the center of the rectangle face that comes up after extrusion
# The hole is 2 units in diameter
result = extruded_rectangle.faces(">Z").workplane().hole(2)

# Export the result as an STL file
result.val().exportStl("Refine_V_2.stl")
