
import cadquery as cq
import math

# Define the side length of the octagon
side_length = 10.0

# Calculate the circumradius of a regular octagon using trigonometric relations
circumradius = side_length / (2 * math.sin(math.pi / 8))

# Create the 3D object: a regular octagon that is extruded to a consistent depth
result = (
    cq.Workplane("XY")
    .polygon(8, circumradius)  # Using polygon function to ensure equal side length and uniform angles
    .extrude(5.0)  # Extruding the octagon to create a 3D object with a consistent depth across its structure
)

# Export the result to an STL file, updated file name as per feedback
result.val().exportStl("Refine_V_1.stl")
