
import cadquery as cq

# Define the base of the triangle and height to ensure isosceles property with right angles at the base
base_length = 1.0
height = base_length / 2 * (2**0.5)  # Calculated so the base angles are 90 degrees (height forms a square's diagonal when base is split in half)

# Defining the points based on the calculations above
points = [(0, 0), (base_length, 0), (base_length / 2, height)]

# Creating the triangle
result = cq.Workplane("XY").polyline(points).close()

# Extruding the triangle
result = result.extrude(1.0)

# Exporting to STL
result.val().exportStl("Refine_V_2.stl")
