
import cadquery as cq

circle_radius = 10.0
hole_radius = circle_radius / 2.0

result = (
    cq.Workplane("XY")
    .circle(circle_radius)
    .extrude(1.0)
    .faces(">Z")
    .workplane()
    .hole(hole_radius)  # Diameter is directly half the diameter of the circle
)

result.val().exportStl("Refine_V_1.stl")
