
import cadquery as cq

circle_radius = 10.0  # Radius of the circle
hole_radius = circle_radius / 2.0  # Radius of the hole, exactly half of the circle radius

result = (
    cq.Workplane("XY")
    .circle(circle_radius)  # Create the main circle with the specified radius
    .extrude(1.0)  # Extrude the circle to create a 3D object
    .faces(">Z")  # Select the top face
    .workplane()  # Start a new workplane on the selected face
    .hole(hole_radius * 2)  # Create a hole using the diameter (2 * radius)
)

result.val().exportStl("Refine_V_2.stl")  # Export the model to an STL file
