
import cadquery as cq

# Define the points for the triangles
points = [
    (0, 0),  # Start point
    (1, 2),  # First peak
    (2, 0),  # Base between first and second peak
    (3, 3),  # Second peak (equilateral triangle)
    (4, 0),  # Base between second and third peak
    (5, 2),  # Third peak
    (6, 0)   # End point
]

# Create the profile and extrude it
result = cq.Workplane("front").polyline(points).close().extrude(1)

# Export the result
result.val().exportStl("Generated.stl")
