
import cadquery as cq

# Create a new workplane that is offset from the origin
result = cq.Workplane("XY")

# Create two overlapping circles by offsetting one from the center
first_circle_radius = 30
second_circle_radius = 30
offset_distance = 15  # Controls how much the circles overlap

# Draw first circle
result = result.circle(first_circle_radius)

# Move the workplane center, then draw the second circle
result = result.center(offset_distance, 0).circle(second_circle_radius)

# Fuse both circles into a single sketch
result = result.combine()

# Extrude the combined sketch to form a cylinder
extrude_height = 100
result = result.extrude(extrude_height)

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
