
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (10, 0), (10, 2), (2, 2), (2, 8), (10, 8), (10, 10), (0, 10)]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(points)

# Mirror the polyline about the Y axis and extrude it into a 3D object
result = r.mirrorY().extrude(1)

# Export the result to STL
result.val().exportStl("Generated.stl")
