
import cadquery as cq

# Defining the points for the U-shaped profile
# This creates a simple rectangular 'U' shape
points = [(0, 0), (10, 0), (10, 2), (2, 2), (2, 8), (10, 8), (10, 10), (0, 10)]

# Create a workplane to draw the profile on
# The U-shape starts from the bottom-left corner, goes right, and makes the shape of U
r = cq.Workplane("front").polyline(points).close()

# Extruding the polyline to create a 3D object
# The extrusion is small (specified here as 1 mm to match the original code for consistency)
result = r.extrude(1)

# Saving the result to an STL file
result.val().exportStl("Refine_V_1.stl")
