
import cadquery as cq

# Defining the points to create a U-shaped outline
points = [(0, 0), (10, 0), (10, 2), (2, 2), (2, 8), (10, 8), (10, 10), (0, 10)]

# Create a workplane to draw on, then add the polyline and close it to form a loop
r = cq.Workplane("front").polyline(points).close()

# Extrude the 2D U-shaped sketch to form a 3D object with adjusted thickness of 0.5
result = r.extrude(0.5)

# Save the result to an STL file
result.val().exportStl("Refine_V_2.stl")
