
import cadquery as cq

# Dimension of the rectangular object
length = 20
width = 10
height = 5

# Creating the base rectangle and extruding it
result = cq.Workplane("front").rect(length, width).extrude(height)

# Hole specifications
hole_diameter = 1.5

# Positioning the hole exactly at the top right corner of the top face
# Since the origin is at the center of the rectangle, the top right is at (length/2, width/2)
result = result.faces(">Z").workplane().center(length / 2, width / 2).hole(hole_diameter)

# Exporting the final model as STL
result.val().exportStl("Refine_V_2.stl")
