
import cadquery as cq

square_size = 10.0
triangle_height = square_size
extrude_depth = 2.0

# Create a workplane
result = cq.Workplane("front")

# Create an irregular rhombus - Alter the points for an irregular shape
result = result.polyline([
    (0, 0),
    (square_size * 0.8, square_size * 0.1),  # Slightly offset vertex creates the irregularity
    (square_size, square_size),
    (square_size * 0.2, square_size * 0.9)   # Slightly offset vertex
]).close()

# Move to the top center of the square and add a right triangle
result = result.moveTo(square_size * 0.5, square_size).lineTo(square_size / 2, square_size + triangle_height).lineTo(square_size, square_size).close()

# Extrude the entire sketch to create a 3D object
result = result.extrude(extrude_depth)

# Save the result to an STL file
result.val().exportStl("Refine_V_2.stl")
