
import cadquery as cq

# Define dimensions
square_side = 10.0
thickness = 0.5
hole_diameter = 0.1

# Create the 3D model
result = (
    cq.Workplane("XY")
    .rect(square_side, square_side)  # Create a square
    .extrude(thickness)              # Extrude the square to create a solid
)

# Add a hole in the center
result = (
    result.faces(">Z")               # Select the top face
    .workplane()                     # Create a workplane on the selected face
    .hole(hole_diameter)             # Punch a hole in the center
)

# Export the model to an STL file
result.val().exportStl("Refine_V_1.stl")
