
import cadquery as cq

# Create a new work plane, this is where sketching takes place
result = cq.Workplane("XY")

# To easily create a crescent, consider constructing two full circles and then subtracting them

# Create outer full circle
outer_circle = result.circle(20)

# Create inner full circle
inner_circle = result.circle(15)

# Subtract inner circle from outer circle to form a ring
ring = outer_circle.cut(inner_circle)

# Now, add an extrusion to give 3D form
solid_crescent = ring.extrude(5)

# Export the finished model to an STL file
solid_crescent.val().exportStl("Refine_V_1.stl")
