
import cadquery as cq

# Create a sketch of a rectangle
r = cq.Workplane("front").rect(2.0, 1.0)

# Create a right trapezoid shape, base is 1.0 and height is 0.5
# since the original rectangle is centered at origin (0,0), we must define shapes relative to origin
r = r.moveTo(-1.0, 0.5).lineTo(0.0, 0.5).lineTo(0.0, -0.5).lineTo(-1.0, -0.5).close()

# Extrude the sketch to create a 3D object
result = r.extrude(1.0)

# Save the output
result.val().exportStl("Generated.stl")
