
import cadquery as cq

outer_radius = 10.0
inner_radius = 8.0
extrude_length = 20.0

result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(extrude_length, both=True) # Ensuring extrusion is centered and along x-axis
)

result.val().exportStl("Refine_V_1.stl")
