
import cadquery as cq

book_thickness = 20.0
book_width = 100.0
book_height = 200.0
spine_thickness = 4.0
page_thickness = book_thickness - spine_thickness

# Base for the book cover
left_cover = cq.Workplane("front").box(book_width, book_height, spine_thickness)
right_cover = cq.Workplane("front").transformed(offset=(book_width, 0, 0), rotate=(0, 0, 45)).box(book_width, book_height, spine_thickness)

# Pages
num_pages = 50
page_sep = page_thickness / num_pages

pages = left_cover
for i in range(num_pages):
    offset = spine_thickness + i * page_sep
    pages = pages.union(cq.Workplane("front").transformed(offset=(0, 0, offset)).box(book_width, book_height, page_sep))

pages = pages.union(cq.Workplane("front").transformed(offset=(book_width, 0, spine_thickness), rotate=(0, 0, 45)).box(book_width, book_height, page_thickness))

# Combine covers and pages
result = left_cover.union(right_cover).union(pages)

result.val().exportStl("Refine_V_1.stl")
