
import cadquery as cq

# Define the points for the irregular hexagon shape.
# Previously there were only 5 points, now we add an additional point to make it a hexagon.
points = [(0, 0), (10, 0), (12, 3), (8, 5), (2, 5), (0, 3)]

# Create a workplane and use polyline to sketch the hexagon based on the defined points.
r = cq.Workplane("front").polyline(points)

# Close the polyline to make a closed loop and extrude it to create a thin tile-like shape.
# Reducing extrusion thickness from 0.5 to 0.2 for a less bulky look.
result = r.close().extrude(0.2)

# Save the output as an STL file with the updated name.
result.val().exportStl("Refine_V_1.stl")
