
import cadquery as cq

# Defining points to form a rectangle with top two corners cut off
# The coordinates create a flat bottom, diagonal sides on the top, and two vertical sides
points = [(0, 0), (10, 0), (10, 3), (8, 5), (2, 5), (0, 3)]

# Creates a new workplane and draws the defined irregular hexagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the area in z-direction to form the tile
result = r.extrude(0.2)

# Save the result as STL
result.val().exportStl("Refine_V_2.stl")
