
import cadquery as cq
import math

# Number of points in the star
num_points = 5
# Outer and inner radius for the star
radius_outer = 10.0
radius_inner = 5.0
# Height of the extrusion
extrude_height = 5.0

# Calculate the angles for the star points and indentations
angle_outer = 2.0 * math.pi / num_points
angle_inner = angle_outer / 2
angle_offset = 0.05  # Slight angle offset for each vertex

# Create the workplane
result = cq.Workplane("XY")

# Initialize starting point
result = result.moveTo(radius_outer, 0)

# Loop to create the star shape
for i in range(num_points):
    # Outer point of star
    angle1 = (i + 1) * angle_outer + i * angle_offset
    point_outer = (radius_outer * math.cos(angle1), radius_outer * math.sin(angle1))
    result = result.lineTo(*point_outer)
    
    # Inner point of star
    angle2 = (i + 1) * angle_outer + angle_inner + (i + 0.5) * angle_offset
    point_inner = (radius_inner * math.cos(angle2), radius_inner * math.sin(angle2))
    result = result.lineTo(*point_inner)

# Complete the sketch and extrude
result = result.close().extrude(extrude_height)

# Save the output
result.val().exportStl("Refine_V_2.stl")
