
import cadquery as cq

# Define the cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Define the trapezium cutout as a sector of the circle
trapezium = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .lineTo(10, 0)  # line out to the edge of the circle
    .radiusArc((10, 10), 10)  # arc around the edge to the other line
    .lineTo(0, 0)  # line back to the origin
    .close()
    .extrude(20)
)

# Subtract the trapezium cutout from the cylinder
result = cylinder.cut(trapezium)

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
