
import cadquery as cq

width = 90.0
height = 60.0
cutout_size = width / 3.0

# Creating the main rectangle
result = cq.Workplane("front").rect(width, height).extrude(height)

# Positioning and creating the square cutout
# The cutout's top edge needs to be placed at the center of the top edge of the rectangle
cutout_position = height / 2.0  # This places the top edge of the cutout at the center top of the rectangle

result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox")\
    .rect(cutout_size, cutout_size, centered=[True, False])\
    .translate((0, cutout_position - cutout_size / 2.0, 0))\
    .cutBlind(-height)

result.val().exportStl("Refine_V_1.stl")
