
import cadquery as cq

# Rectangular base dimensions
width = 90.0
height = 60.0  # 2/3 of the width

# Parameters for the square cutout
cutout_size = width / 3.0
cutout_position = height / 2.0

# Creating the base rectangle and extruding it to the specified height
result = cq.Workplane("front").rect(width, height).extrude(height)

# Placing the square cutout at the center of the top edge of the rectangle
# Cutting the square through the extruded object
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox") \
    .rect(cutout_size, cutout_size, centered=[True, False]) \
    .translate((0, cutout_position - cutout_size / 2.0, 0)) \
    .cutBlind(-height)

# Export the result as an STL file
result.val().exportStl("Refine_V_2.stl")
