
import cadquery as cq

# Define main cylinder dimensions
diameter = 20
height = 10

# Create the main cylindrical body of the whistle
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Define dimensions of the rectangular block to be added
block_length = diameter * 1.2  # longer than the diameter of the cylinder
block_width = 3
block_height = 2

# Create the rectangular block 
block = (
    cq.Workplane("XY")
    .workplane(offset=height)
    .center(0, diameter / 2)
    .rect(block_length, block_width)
    .extrude(block_height)
    .rotate((0, 0, 0), (1, 0, 0), 90)  # rotate to correct the block's orientation
)

# Union the block with the cylinder
whistle = cylinder.union(block)

# Adding a hole for blowing air
hole_diameter = 5
whistle = whistle.faces(">Z").workplane().hole(hole_diameter)

# Save the refined model to an STL file
whistle.val().exportStl("Refine_V_1.stl")
