
import cadquery as cq

head_diameter = 10.0
head_height = 5.0
screw_diameter = 4.0
screw_length = 20.0
inner_circle_diameter = 2.0  # Diameter for the smaller circle in the hex head

# Create a hexagonal head
result = cq.Workplane("XY").polygon(6, head_diameter).extrude(head_height)

# Add a smaller circle inside the hexagonal head and extrude it outward
result = result.faces(">Z").workplane() \
    .circle(inner_circle_diameter / 2).extrude(-0.5)  # Negative extrusion for inset

# Create the screw bolt
result = result.faces(">Z").workplane().circle(screw_diameter / 2).extrude(screw_length)

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
