
import cadquery as cq

head_diameter = 10.0  # diameter of the hexagonal head
head_height = 5.0     # height of the hexagonal head
screw_diameter = 4.0  # diameter of the screw shaft
screw_length = 20.0   # length of the screw shaft
inner_circle_diameter = 2.0  # diameter of the inner circle in the hexagon

# Create the hexagonal head
result = cq.Workplane("XY").polygon(6, head_diameter).extrude(head_height)

# Add a circle in the center of the hexagonal head and extrude it outward to form the bolt
result = result.faces(">Z").workplane()\
    .circle(screw_diameter / 2).extrude(screw_length)

# Save the model as STL
result.val().exportStl("Refine_V_2.stl")
