
import cadquery as cq

# Define the heart shape using appropriate spline points
points = [
    (0, -2),   # Tip of the heart
    (1, 0),    # Right side bottom of upper lobe
    (1.5, 1),  # Right side upper point of the lobe
    (1, 2),    # Right side top-most part of the heart
    (0, 1.5),   # Middle top dent
    (-1, 2),   # Symmetry for left lobe, top-most
    (-1.5, 1),  # Symmetry for left lobe, upper
    (-1, 0),    # Symmetry for left bottom of upper lobe
    (0, -2)    # Back to the tip
]

result = (
    cq.Workplane("front")
    # Build the heart wire and make a closed loop
    .polyline(points).close()
    # Use mirrorY to ensure the symmetry about the Y-axis
    .mirrorY()
    # Extrude to add the 3rd dimension
    .extrude(1)
)

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
