
import cadquery as cq

base = 10.0
height = 25.0  # Adjusted height to be clearly more than twice the base
thickness = 0.5  # Thickness for both extrusion and inner hollow gap

result = (
    cq.Workplane("front")
    # Drawing the outer triangle
    .moveTo(0, 0)
    .lineTo(base, 0)
    .lineTo(0, height)
    .close()
    # Creating a hollow section
    .offset2D(-thickness)  # Making an inner offset to hollow out the triangle
    .extrude(thickness)  # Extruding the hollow triangle
)

# Exporting to STL with the updated name as requested
result.val().exportStl("Refine_V_1.stl")
