
import cadquery as cq

hexagon_edge_length = 10.0  # edge length of the hexagon
hexagon_height = 20.0  # desired extrusion height of the hexagon
cylinder_diameter = hexagon_edge_length - 1.0  # cylinder is slightly smaller than the hexagon
cylinder_height = hexagon_height / 2.0  # cylinder height should be half of the hexagon height

result = (
    cq.Workplane("XY")  # Begin a new sketch on the XY plane
    .polygon(6, hexagon_edge_length)  # Draw a polygon with 6 sides (hexagon) with defined edge length
    .extrude(hexagon_height)  # Extrude the hexagon to the desired height
)

result = (
    result.faces(">Z")  # Selects the top face of the hexagon
    .workplane()  # Starts a new workplane on the selected face
    .circle(cylinder_diameter / 2.0)  # Draw a circle for the cylinder with required diameter
    .extrude(cylinder_height)  # Extrude the circle to make the cylinder to the updated height
)

result.val().exportStl("Refine_V_1.stl")  # Export the final model as STL file
