
import cadquery as cq

hexagon_edge_length = 10.0
hexagon_height = 20.0
cylinder_diameter = hexagon_edge_length - 1.0
cylinder_height = hexagon_height / 2.0

result = (
    cq.Workplane("XY")
    .polygon(6, hexagon_edge_length)
    .extrude(hexagon_height)
)

result = (
    result.faces(">Z")
    .workplane()
    .circle(cylinder_diameter / 2.0)
    .extrude(cylinder_height)
)

result.val().exportStl("Refine_V_2.stl")
