
import cadquery as cq

# Create a cylinder with a radius of 5 and a height of 20
cylinder = cq.Workplane("XY").circle(5).extrude(20)

# Create and extrude a circle larger than the cylinder's radius near the top of the cylinder
# Increase extrusion height from 5 to 15 for vertical extension
circle = cq.Workplane("XY").workplane(offset=18).circle(10).extrude(15)  

# Unite the cylinder and the vertically extended circle
result = cylinder.union(circle)

# Export the updated model to an STL file
result.val().exportStl("Refine_V_1.stl")
