
import cadquery as cq

# Parameters for the main rectangular plate
length = 100.0
width = 50.0
thickness = 10.0

# Parameters for the circular holes
hole_diameter = 5.0  # Diameter for each hole
number_of_holes = 3  # Total number of holes required

# Calculate positions for the holes to be symmetric and closer to the top left corner
# Assume holes will be distributed along the top half, starting close to the top left corner
hole_spacing_x = length / (2*(number_of_holes + 1))  # space between holes along the length, adjusted to move closer to the left
hole_spacing_y = width / 4  # set the holes in the upper quarter closer to the left

# Create the main rectangular solid plate
plate = cq.Workplane("XY").box(length, width, thickness)

# Hole positions based on feedback for symmetry and specific alignment
hole_positions = [(hole_spacing_x * (1 + i), hole_spacing_y) for i in range(number_of_holes)]

# Cut holes in the plate
for pos in hole_positions:
    plate = plate.faces(">Z").workplane().pushPoints([pos]).hole(hole_diameter)

# Export the refined model to STL
plate.val().exportStl("Refine_V_1.stl")
