
import cadquery as cq

# Create a square base
base = cq.Workplane("front").rect(1, 1)

# Attach a semi-circle to the top side of the square
semi_circle = base.moveTo(0.5, 0.5).threePointArc((1, 1), (1.5, 0.5))

# Complete the sketch and extrude
result = semi_circle.close().extrude(1)

# Save the output
result.val().exportStl("Refine_V_2.stl")
