
import cadquery as cq

extrusion_height = 2

# Create a base rectangle extruded to 'extrusion_height', starting from z=0
base = cq.Workplane("XY").rect(10, 5).extrude(extrusion_height)

# Create a second rectangle on the same plane, also extruded to 'extrusion_height'
top = cq.Workplane("XY").workplane(offset=extrusion_height).rect(8, 4).extrude(extrusion_height)

# Union the two extruded parts into a single object
result = base.union(top)

# Save the model as STL
result.val().exportStl("Refine_V_2.stl")
