
import cadquery as cq

# Defining the height of the rectangle and the cylinders as equal
height = 0.5

# Creating the base rectangle
rectangle = cq.Workplane("XY").rect(10, 2).extrude(height)

# Creating the first cylinder, match the height with the rectangle
cylinder1 = cq.Workplane("XY").workplane(offset=height).center(-4, 0).circle(0.5).extrude(height)

# Creating the second cylinder, at the same height as the rectangle
cylinder2 = cq.Workplane("XY").workplane(offset=height).center(-6, 0).circle(0.5).extrude(height)

# Union the rectangle with the two cylinders
result = rectangle.union(cylinder1).union(cylinder2)

# Export the final result to STL file
result.val().exportStl("Refine_V_1.stl")
