
import cadquery as cq

height = 0.5

# Creating the main rectangle body
rectangle = cq.Workplane("XY").rect(10, 2).extrude(height)

# Positioning and creating the first cylinder
cylinder1 = cq.Workplane("XY").workplane(offset=height).center(-4.5, 0).circle(0.5).extrude(height)

# Positioning and creating the second cylinder right next to the first
cylinder2 = cq.Workplane("XY").workplane(offset=height).center(-5.5, 0).circle(0.5).extrude(height)

# Combining the rectangle with both cylinders
result = rectangle.union(cylinder1).union(cylinder2)

# Saving the output as an STL file
result.val().exportStl("Refine_V_2.stl")
